/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousInitializerSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002R\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUninitializedEnumChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "lazyDelegation", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getLazyDelegation", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "isEnumEntryInitializer", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUninitializedEnumChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUninitializedEnumChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUninitializedEnumChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,270:1\n84#2:271\n44#2:273\n37#3:272\n1761#4,3:274\n808#4,11:277\n808#4,11:288\n808#4,11:299\n808#4,11:313\n543#4,6:328\n543#4,6:334\n313#5,3:310\n316#5,4:324\n*S KotlinDebug\n*F\n+ 1 FirUninitializedEnumChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUninitializedEnumChecker\n*L\n86#1:271\n90#1:273\n86#1:272\n107#1:274,3\n114#1:277,11\n115#1:288,11\n116#1:299,11\n119#1:313,11\n122#1:328,6\n139#1:334,6\n117#1:310,3\n117#1:324,4\n*E\n"})
public final class FirUninitializedEnumChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirUninitializedEnumChecker INSTANCE = new FirUninitializedEnumChecker();

    private FirUninitializedEnumChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        FirAnonymousFunction lazyDelegation;
        FirDeclaration firDeclaration;
        List<FirDeclaration> accessedContext;
        Map enumEntriesInitBlocks;
        List enumEntries;
        List enumInitBlocks;
        List enumMemberProperties;
        FirBasedSymbol calleeSymbol;
        KtSourceElement source;
        block35: {
            FirDeclaration firDeclaration2;
            FirDeclaration it;
            FirDeclaration element$iv;
            ListIterator<FirDeclaration> iterator$iv;
            boolean $i$f$lastOrNull;
            List<FirDeclaration> $this$lastOrNull$iv;
            block34: {
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstanceTo$iv$iv2;
                void $this$filterIsInstanceTo$iv$iv3;
                boolean isInsideCorrespondingEnum;
                Object it2;
                FirRegularClassSymbol enumClassSymbol;
                block33: {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperUninitializedEnumEntryAccessAnalysis)) {
                        return;
                    }
                    KtSourceElement ktSourceElement = expression2.getSource();
                    if (ktSourceElement == null) {
                        return;
                    }
                    source = ktSourceElement;
                    if (source.getKind() instanceof KtFakeSourceElementKind) {
                        return;
                    }
                    FirBasedSymbol firBasedSymbol = FirReferenceUtilsKt.toResolvedBaseSymbol$default(expression2.getCalleeReference(), false, 1, null);
                    if (firBasedSymbol == null) {
                        return;
                    }
                    calleeSymbol = firBasedSymbol;
                    FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(calleeSymbol);
                    FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                    if (firRegularClassSymbol == null) {
                        return;
                    }
                    enumClassSymbol = firRegularClassSymbol;
                    FirClassSymbol $this$isEnumClass$iv = enumClassSymbol;
                    boolean $i$f$isEnumClass = false;
                    ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                    boolean $i$f$isEnumClass2 = false;
                    if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
                        return;
                    }
                    FirClassLikeSymbol $this$visibility$iv = enumClassSymbol;
                    boolean $i$f$getVisibility = false;
                    if (Intrinsics.areEqual((Object)$this$visibility$iv.getResolvedStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE) && calleeSymbol instanceof FirEnumEntrySymbol) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNINITIALIZED_ENUM_ENTRY(), (Object)calleeSymbol, null, 16, null);
                    }
                    Iterable $this$any$iv = context2.getContainingDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            it2 = (FirDeclaration)element$iv2;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(FirHelpersKt.getContainingClassSymbol((FirDeclaration)it2), (Object)enumClassSymbol)) continue;
                            bl = true;
                            break block33;
                        }
                        bl = isInsideCorrespondingEnum = false;
                    }
                }
                if (!isInsideCorrespondingEnum) {
                    return;
                }
                List<FirBasedSymbol<?>> declarationSymbols = enumClassSymbol.getDeclarationSymbols();
                Iterable $this$filterIsInstance$iv = declarationSymbols;
                boolean $i$f$filterIsInstance = false;
                it2 = $this$filterIsInstance$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                    if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                enumMemberProperties = (List)destination$iv$iv;
                Iterable $this$filterIsInstance$iv2 = declarationSymbols;
                boolean $i$f$filterIsInstance2 = false;
                destination$iv$iv = $this$filterIsInstance$iv2;
                Iterable destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof FirAnonymousInitializerSymbol)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                enumInitBlocks = (List)destination$iv$iv2;
                Iterable $this$filterIsInstance$iv3 = declarationSymbols;
                boolean $i$f$filterIsInstance3 = false;
                destination$iv$iv2 = $this$filterIsInstance$iv3;
                Object destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo3 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof FirEnumEntrySymbol)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                List $this$flatAssociateBy$iv = enumEntries = (List)destination$iv$iv3;
                boolean $i$f$flatAssociateBy = false;
                Object $this$flatAssociateBy_u24lambda_u248$iv = destination$iv$iv3 = MapsKt.createMapBuilder();
                boolean bl = false;
                for (Object value$iv : $this$flatAssociateBy$iv) {
                    List list;
                    List list2;
                    FirEnumEntrySymbol it3 = (FirEnumEntrySymbol)value$iv;
                    boolean bl3 = false;
                    Object object = it3.getInitializerObjectSymbol();
                    if (object != null && (object = ((FirClassSymbol)object).getDeclarationSymbols()) != null) {
                        void $this$filterIsInstanceTo$iv$iv4;
                        Iterable $this$filterIsInstance$iv4 = (Iterable)object;
                        boolean $i$f$filterIsInstance4 = false;
                        Iterable iterable = $this$filterIsInstance$iv4;
                        Collection destination$iv$iv4 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo4 = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv4) {
                            if (!(element$iv$iv instanceof FirAnonymousInitializerSymbol)) continue;
                            destination$iv$iv4.add(element$iv$iv);
                        }
                        list2 = (List)destination$iv$iv4;
                    } else {
                        list2 = list = null;
                    }
                    if (list2 == null) {
                        list = CollectionsKt.emptyList();
                    }
                    for (Object key$iv : (Collection)list) {
                        $this$flatAssociateBy_u24lambda_u248$iv.put(key$iv, value$iv);
                    }
                }
                enumEntriesInitBlocks = MapsKt.build((Map)destination$iv$iv3);
                $this$lastOrNull$iv = context2.getContainingDeclarations();
                $i$f$lastOrNull = false;
                iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = element$iv = iterator$iv.previous();
                    boolean bl4 = false;
                    if (!(Intrinsics.areEqual(FirHelpersKt.getContainingClassSymbol(it), (Object)enumClassSymbol) || enumEntriesInitBlocks.containsKey(it.getSymbol()))) continue;
                    firDeclaration2 = element$iv;
                    break block34;
                }
                firDeclaration2 = null;
            }
            FirDeclaration $i$f$flatAssociateBy = firDeclaration2;
            if ($i$f$flatAssociateBy == null || ($this$lastOrNull$iv = $i$f$flatAssociateBy.getSymbol()) == null) {
                return;
            }
            accessedContext = $this$lastOrNull$iv;
            $this$lastOrNull$iv = context2.getContainingDeclarations();
            $i$f$lastOrNull = false;
            iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = element$iv = iterator$iv.previous();
                boolean bl = false;
                boolean bl5 = it instanceof FirCallableDeclaration ? FirDeclarationUtilKt.isNonLocal(it) || ((FirCallableDeclaration)it).getDispatchReceiverType() != null : false;
                if (!bl5) continue;
                firDeclaration = element$iv;
                break block35;
            }
            firDeclaration = null;
        }
        FirDeclaration containingDeclarationForAccess = firDeclaration;
        if (CollectionsKt.contains((Iterable)enumMemberProperties, accessedContext) && (lazyDelegation = this.getLazyDelegation((FirPropertySymbol)((Object)accessedContext))) != null) {
            return;
        }
        if (CollectionsKt.contains((Iterable)enumEntries, accessedContext)) {
            FirDeclaration firDeclaration3 = containingDeclarationForAccess;
            if (!(firDeclaration3 != null ? this.isEnumEntryInitializer(firDeclaration3) : false)) {
                return;
            }
        }
        if (CollectionsKt.contains((Iterable)enumEntries, (Object)calleeSymbol)) {
            FirEnumEntrySymbol calleeEnumEntry = (FirEnumEntrySymbol)calleeSymbol;
            List<FirDeclaration> list = accessedContext;
            if (CollectionsKt.contains((Iterable)enumMemberProperties, list) || CollectionsKt.contains((Iterable)enumInitBlocks, list)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNINITIALIZED_ENUM_ENTRY(), (Object)calleeEnumEntry, null, 16, null);
            } else if (CollectionsKt.contains((Iterable)enumEntries, list)) {
                FirUninitializedEnumChecker.check$reportIllegalAccessInEnumEntry(enumEntries, calleeEnumEntry, context2, reporter, source, (FirEnumEntrySymbol)((Object)accessedContext));
            } else if (enumEntriesInitBlocks.containsKey(list)) {
                FirEnumEntrySymbol entrySymbol = (FirEnumEntrySymbol)MapsKt.getValue((Map)enumEntriesInitBlocks, (Object)((FirAnonymousInitializerSymbol)((Object)accessedContext)));
                if (Intrinsics.areEqual((Object)entrySymbol, (Object)calleeSymbol)) {
                    return;
                }
                FirUninitializedEnumChecker.check$reportIllegalAccessInEnumEntry(enumEntries, calleeEnumEntry, context2, reporter, source, entrySymbol);
            }
        }
    }

    private final FirAnonymousFunction getLazyDelegation(FirPropertySymbol $this$lazyDelegation) {
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$lazyDelegation, FirResolvePhase.BODY_RESOLVE);
        FirProperty property2 = (FirProperty)$this$lazyDelegation.getFir();
        if (property2.getDelegate() == null || !(property2.getDelegate() instanceof FirFunctionCall)) {
            return null;
        }
        FirExpression firExpression = property2.getDelegate();
        Intrinsics.checkNotNull((Object)firExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
        FirFunctionCall delegateCall = (FirFunctionCall)firExpression;
        FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default(delegateCall.getCalleeReference(), false, 1, null);
        if (firNamedFunctionSymbol == null) {
            return null;
        }
        FirNamedFunctionSymbol calleeSymbol = firNamedFunctionSymbol;
        if (!Intrinsics.areEqual((Object)calleeSymbol.getCallableId().asSingleFqName().asString(), (Object)"kotlin.lazy")) {
            return null;
        }
        Object object = CollectionsKt.singleOrNull(delegateCall.getArgumentList().getArguments());
        FirAnonymousFunctionExpression firAnonymousFunctionExpression = object instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)object : null;
        if (firAnonymousFunctionExpression == null) {
            return null;
        }
        FirAnonymousFunctionExpression lazyCallArgument = firAnonymousFunctionExpression;
        return lazyCallArgument.getAnonymousFunction();
    }

    private final boolean isEnumEntryInitializer(FirDeclaration $this$isEnumEntryInitializer) {
        FirClassLikeSymbol<Object> firClassLikeSymbol;
        FirDeclaration firDeclaration = $this$isEnumEntryInitializer;
        if (firDeclaration instanceof FirConstructor) {
            if (!((FirConstructor)$this$isEnumEntryInitializer).isPrimary()) {
                return false;
            }
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.getContainingClassForStaticMemberAttr((FirCallableDeclaration)$this$isEnumEntryInitializer);
            ConeClassLikeLookupTagWithFixedSymbol coneClassLikeLookupTagWithFixedSymbol = coneClassLikeLookupTag instanceof ConeClassLikeLookupTagWithFixedSymbol ? (ConeClassLikeLookupTagWithFixedSymbol)coneClassLikeLookupTag : null;
            firClassLikeSymbol = coneClassLikeLookupTagWithFixedSymbol != null ? coneClassLikeLookupTagWithFixedSymbol.getSymbol() : null;
        } else {
            FirBasedSymbol<?> firBasedSymbol;
            firClassLikeSymbol = firDeclaration instanceof FirAnonymousInitializer ? (FirClassLikeSymbol<?>)((firBasedSymbol = ((FirAnonymousInitializer)$this$isEnumEntryInitializer).getContainingDeclarationSymbol()) instanceof FirClassSymbol ? (FirClassSymbol)firBasedSymbol : null) : null;
        }
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> containingClassSymbol = firClassLikeSymbol;
        return FirHelpersKt.getClassKind(containingClassSymbol) == ClassKind.ENUM_ENTRY;
    }

    private static final void check$reportIllegalAccessInEnumEntry(List<FirEnumEntrySymbol> enumEntries, FirEnumEntrySymbol calleeEnumEntry, CheckerContext $context, DiagnosticReporter $reporter, KtSourceElement source, FirEnumEntrySymbol correspondingEnumEntry) {
        FirEnumEntrySymbol precedingEntry = null;
        for (FirEnumEntrySymbol it : enumEntries) {
            if (!Intrinsics.areEqual((Object)it, (Object)calleeEnumEntry) && !Intrinsics.areEqual((Object)it, (Object)correspondingEnumEntry)) continue;
            precedingEntry = it;
            break;
        }
        if (Intrinsics.areEqual(precedingEntry, (Object)correspondingEnumEntry)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNINITIALIZED_ENUM_ENTRY(), (Object)calleeEnumEntry, null, 16, null);
        }
    }
}

