/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.Job;
import org.dita.dost.util.Pool;
import org.dita.dost.writer.ImageMetadataFilter;
import org.xml.sax.Attributes;

final class ImageMetadataModule
extends AbstractPipelineModuleImpl {
    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        Collection<Job.FileInfo> images = this.job.getFileInfo(f -> "image".equals(f.format) || "html".equals(f.format));
        if (!images.isEmpty()) {
            File outputDir = new File(input.getAttribute("outputdir"));
            Predicate filter = this.fileInfoFilter != null ? this.fileInfoFilter : f -> !f.isResourceOnly && "dita".equals(f.format);
            ConcurrentHashMap<URI, Attributes> cache = new ConcurrentHashMap<URI, Attributes>();
            if (this.parallel) {
                Pool<ImageMetadataFilter> pool = new Pool<ImageMetadataFilter>(() -> {
                    ImageMetadataFilter writer = new ImageMetadataFilter(outputDir, this.job, cache);
                    writer.setLogger(this.logger);
                    writer.setJob(this.job);
                    return writer;
                });
                ((Stream)this.job.getFileInfo(filter).stream().parallel()).map(f -> new File(this.job.tempDirURI.resolve(f.uri)).getAbsoluteFile()).forEach(filename -> {
                    ImageMetadataFilter writer = (ImageMetadataFilter)pool.borrowObject();
                    try {
                        writer.write((File)filename);
                    }
                    finally {
                        pool.returnObject(writer);
                    }
                });
            } else {
                ImageMetadataFilter writer = new ImageMetadataFilter(outputDir, this.job, cache);
                writer.setLogger(this.logger);
                writer.setJob(this.job);
                for (Job.FileInfo f2 : this.job.getFileInfo(filter)) {
                    writer.write(new File(this.job.tempDirURI.resolve(f2.uri)).getAbsoluteFile());
                }
            }
            this.storeImageFormat(cache.keySet(), outputDir);
            try {
                this.job.write();
            }
            catch (IOException e) {
                throw new DITAOTException("Failed to serialize job configuration: " + e.getMessage(), e);
            }
        }
        return null;
    }

    private void storeImageFormat(Collection<URI> images, File outputDir) {
        URI output = outputDir.toURI();
        URI temp = this.job.tempDirURI;
        for (URI f : images) {
            Job.FileInfo fi;
            assert (f.isAbsolute());
            URI rel = output.relativize(f);
            if (rel.isAbsolute()) {
                rel = temp.relativize(f);
            }
            if ((fi = this.job.getFileInfo(rel)) == null) continue;
            this.logger.debug("Set " + String.valueOf(fi.uri) + " format to image");
            this.job.add(new Job.FileInfo.Builder(fi).format("image").build());
        }
    }
}

